"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.signOut = exports.sendEmailVerification = exports.signInWithEmailAndPassword = exports.createUserWithEmailAndPassword = exports.auth = exports.app = exports.db = void 0;
const app_1 = require("firebase/app");
const firestore_1 = require("firebase/firestore");
const dotenv_1 = __importDefault(require("dotenv"));
const auth_1 = require("firebase/auth");
Object.defineProperty(exports, "createUserWithEmailAndPassword", { enumerable: true, get: function () { return auth_1.createUserWithEmailAndPassword; } });
Object.defineProperty(exports, "signInWithEmailAndPassword", { enumerable: true, get: function () { return auth_1.signInWithEmailAndPassword; } });
Object.defineProperty(exports, "signOut", { enumerable: true, get: function () { return auth_1.signOut; } });
Object.defineProperty(exports, "sendEmailVerification", { enumerable: true, get: function () { return auth_1.sendEmailVerification; } });
dotenv_1.default.config();
const { FIREBASE_API_KEY, FIREBASE_AUTH_DOMAIN, FIREBASE_PROJECT_ID, FIREBASE_STORAGE_BUCKET, FIREBASE_MESSAGE_SENDER_ID, FIREBASE_APP_ID, } = process.env;
const firebaseConfig = {
    apiKey: FIREBASE_API_KEY || "",
    authDomain: FIREBASE_AUTH_DOMAIN || "",
    projectId: FIREBASE_PROJECT_ID || "",
    storageBucket: FIREBASE_STORAGE_BUCKET || "",
    messagingSenderId: FIREBASE_MESSAGE_SENDER_ID || "",
    appId: FIREBASE_APP_ID || "",
};
const app = (0, app_1.getApps)().length === 0 ? (0, app_1.initializeApp)(firebaseConfig) : (0, app_1.getApp)();
exports.app = app;
const db = (0, firestore_1.getFirestore)(app);
exports.db = db;
const auth = (0, auth_1.getAuth)();
exports.auth = auth;
