"use strict";
var __importDefault =
  (this && this.__importDefault) ||
  function (mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
Object.defineProperty(exports, "__esModule", { value: true });
exports.bucket = exports.auth = exports.adminDb = exports.AdminApp = void 0;
const firestore_1 = require("firebase-admin/firestore");
const storage_1 = require("firebase-admin/storage");
const app_1 = require("firebase-admin/app");
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const auth_1 = require("firebase-admin/auth");
const serviceKeyPath = path_1.default.resolve(__dirname, "../service_key.json");
const serviceKey = JSON.parse(
  fs_1.default.readFileSync(serviceKeyPath, "utf8")
);
let app;
const { FIREBASE_STORAGE_BUCKET } = process.env;
if ((0, app_1.getApps)().length === 0) {
  exports.AdminApp = app = (0, app_1.initializeApp)({
    credential: (0, app_1.cert)(serviceKey),
    storageBucket: FIREBASE_STORAGE_BUCKET,
  });
} else {
  exports.AdminApp = app = (0, app_1.getApp)();
}
const adminDb = (0, firestore_1.getFirestore)(app);
exports.adminDb = adminDb;
const bucket = (0, storage_1.getStorage)(app).bucket();
exports.bucket = bucket;
const auth = (0, auth_1.getAuth)(app);
exports.auth = auth;
