"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendEmailApproval = exports.sendEmailTask = exports.sendEmail = void 0;
const aws = __importStar(require("@aws-sdk/client-ses"));
const nodemailer_1 = __importDefault(require("nodemailer"));
const ses = new aws.SES({
    region: process.env.AWS_SES_REGION || "",
    credentials: {
        secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY || "",
        accessKeyId: process.env.AWS_ACCESS_KEY || "",
    },
});
// Create Nodemailer SES transporter
const transporter = nodemailer_1.default.createTransport({
    SES: { ses, aws },
    sendingRate: 10, // max 1 message/second,
    maxConnections: 1,
});
const sendEmail = (_a) => __awaiter(void 0, [_a], void 0, function* ({ toEmail, subject, content, isHtml, }) {
    try {
        yield transporter.sendMail({
            from: process.env.AWS_SENDER_EMAIL || "",
            to: toEmail,
            subject,
            [isHtml ? "html" : "text"]: content,
        });
        console.log("Email sent successfully to:", toEmail);
    }
    catch (error) {
        console.error("Error sending email:", error);
        throw error; // Rethrow to handle errors in calling function
    }
});
exports.sendEmail = sendEmail;
const sendEmailTask = (_a) => __awaiter(void 0, [_a], void 0, function* ({ toEmail, fromName, recipientName, link, }) {
    try {
        yield sendEmail({
            toEmail,
            subject: `New Task Assigned by ${fromName}`,
            content: `Dear ${recipientName},\n\nYou have been assigned a new task. Please check the following link:\n\n${link}`,
            isHtml: false,
        });
    }
    catch (error) {
        console.error("Error in sendEmailTask:", error);
    }
});
exports.sendEmailTask = sendEmailTask;
const sendEmailApproval = (_a) => __awaiter(void 0, [_a], void 0, function* ({ toEmail, fromName, recipientName, link, message, }) {
    try {
        const emailContent = `
      Dear ${recipientName},

      ${message}

      You can review the document using the link below:
      ${link}
    `;
        yield sendEmail({
            toEmail,
            subject: `New Document Approval Required from ${fromName}`,
            content: emailContent.trim(),
            isHtml: false,
        });
    }
    catch (error) {
        console.error("Error in sendEmailApproval:", error);
    }
});
exports.sendEmailApproval = sendEmailApproval;
