"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.changePasswordSchema = exports.addUserSchema = exports.UpdateUserSchema = exports.userLoginSchema = exports.userRegisterSchema = void 0;
const zod_1 = require("zod");
const userRegisterSchema = zod_1.z
    .object({
    name: zod_1.z.string().min(1, "Name is required"),
    email: zod_1.z.string().email("Invalid email address"),
    planId: zod_1.z.string().optional(),
    roleId: zod_1.z.string().optional(),
    companyName: zod_1.z.string().min(1, "Company Name is required"),
    password: zod_1.z
        .string()
        .min(8, { message: "Password must contain at least 8 characters" })
        .regex(/[A-Z]/, {
        message: "Password must contain at least one uppercase letter",
    })
        .regex(/[0-9]/, { message: "Password must contain at least one number" })
        .regex(/[\W_]/, { message: "Password must contain at least one symbol" }),
    confirmPassword: zod_1.z.string(),
})
    .refine((data) => data.password === data.confirmPassword, {
    message: "Passwords don't match",
    path: ["confirmPassword"],
});
exports.userRegisterSchema = userRegisterSchema;
const addUserSchema = zod_1.z.object({
    email: zod_1.z.string().email("Invalid email format."),
    name: zod_1.z.string().min(1, "Name is Required"),
    roleId: zod_1.z.string().min(1, "Role is required."),
    workspaceId: zod_1.z.string().min(1, "Workspace ID is required."),
});
exports.addUserSchema = addUserSchema;
const UpdateUserSchema = zod_1.z.object({
    email: zod_1.z.string().email("Invalid email format.").optional(),
    name: zod_1.z.string().optional(),
    roleId: zod_1.z.string().optional(),
    workspaceId: zod_1.z.string().optional(),
    newDocumentNotification: zod_1.z.boolean().optional(),
    commentNotification: zod_1.z.boolean().optional(),
    approvalNotification: zod_1.z.boolean().optional(),
    taskNotification: zod_1.z.boolean().optional(),
});
exports.UpdateUserSchema = UpdateUserSchema;
const changePasswordSchema = zod_1.z
    .object({
    password: zod_1.z
        .string()
        .min(6, "Password must be at least 6 characters long")
        .regex(/[A-Z]/, "Password must contain at least one uppercase letter")
        .regex(/\d/, "Password must contain at least one number"),
    confirmPassword: zod_1.z.string(),
    currentPassword: zod_1.z.string().min(1, "Current Password is Required"),
})
    .refine((data) => data.password === data.confirmPassword, {
    message: "Passwords do not match",
    path: ["confirmPassword"],
});
exports.changePasswordSchema = changePasswordSchema;
const userLoginSchema = zod_1.z.object({
    email: zod_1.z.string().min(1, "Email is required").email("Invalid email address"),
    password: zod_1.z.string().min(8, { message: "Password is required" }),
});
exports.userLoginSchema = userLoginSchema;
