"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editTaskSchema = exports.createTaskSchema = void 0;
const zod_1 = require("zod");
const createTaskSchema = zod_1.z.object({
    title: zod_1.z.string().min(1, "Title is required"),
    tag: zod_1.z.string().min(1, "Tag is Required"),
    status: zod_1.z
        .enum(['pending', 'on progress', 'in review', 'overdue', 'approved', 'rejected'])
        .optional(),
    description: zod_1.z.string().optional(),
    pic: zod_1.z.string().min(1, "PIC is Required"),
    document: zod_1.z.string().optional(),
    deadline: zod_1.z
        .string()
        .min(1)
        .refine((date) => !isNaN(Date.parse(date)), {
        message: "Invalid date format for deadline.",
    }),
});
exports.createTaskSchema = createTaskSchema;
const editTaskSchema = zod_1.z.object({
    title: zod_1.z.string().min(1).optional(),
    tag: zod_1.z.string().optional(),
    status: zod_1.z
        .enum(['pending', 'on progress', 'in review', 'overdue', 'approved', 'rejected'])
        .optional(),
    description: zod_1.z.string().optional(),
    pic: zod_1.z.string().optional(),
    document: zod_1.z.string().optional(),
    deadline: zod_1.z
        .string()
        .optional()
        .refine((date) => {
        if (date === undefined)
            return true;
        return !isNaN(Date.parse(date));
    }, {
        message: "Invalid date format for deadline.",
    }),
});
exports.editTaskSchema = editTaskSchema;
