"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.notificationSchema = void 0;
const zod_1 = require("zod");
const notificationSchema = zod_1.z.object({
    documentId: zod_1.z.string().min(1, "Document ID is required"),
    documentTitle: zod_1.z.string().min(1, "Document Title is required"),
    createdBy: zod_1.z.string().min(1, "Created By (User ID) is required"),
    workspaceId: zod_1.z.string().min(1, "Workspace ID is required"),
    message: zod_1.z.string().optional(),
});
exports.notificationSchema = notificationSchema;
