"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editDocumentSchema = exports.createDocumentSchema = void 0;
const zod_1 = require("zod");
const createDocumentSchema = zod_1.z.object({
    isManual: zod_1.z.boolean().optional(),
    title: zod_1.z.string().min(1, "Document title is required."),
    divisiFolderId: zod_1.z.string().min(1, "Divisi Folder is required."),
    tags: zod_1.z.string().min(1, "Tags Document is required."),
    status: zod_1.z.string().min(1, "Status Document is required."),
    content: zod_1.z.string().optional(),
    extension: zod_1.z.string().optional(),
    categoryId: zod_1.z.string().min(1, "Category ID is required."),
});
exports.createDocumentSchema = createDocumentSchema;
const editDocumentSchema = zod_1.z.object({
    title: zod_1.z.string().min(1, "Document title is required.").optional(),
    tags: zod_1.z.string().optional(),
    status: zod_1.z.string().optional(),
    newDivisiFolderId: zod_1.z.string().optional(),
    content: zod_1.z.string().optional(),
    categoryId: zod_1.z.string().optional(),
    invitedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
        role: zod_1.z.enum(["viewer", "editor", "owner"]),
    }))
        .optional(),
    revokedUsers: zod_1.z
        .array(zod_1.z.object({
        id: zod_1.z.string().min(1, "User ID is required."),
    }))
        .optional(),
    extension: zod_1.z.string().optional(),
});
exports.editDocumentSchema = editDocumentSchema;
