"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editCategoryRecordSchema = exports.createCategoryRecordSchema = void 0;
const zod_1 = require("zod");
const createCategoryRecordSchema = zod_1.z.object({
    categoryName: zod_1.z.string().min(1, "Category name is required."),
});
exports.createCategoryRecordSchema = createCategoryRecordSchema;
const editCategoryRecordSchema = zod_1.z.object({
    categoryName: zod_1.z.string().min(1, "Category name is required.").optional(),
});
exports.editCategoryRecordSchema = editCategoryRecordSchema;
