"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editCategorySchema = exports.createCategorySchema = void 0;
const zod_1 = require("zod");
const createCategorySchema = zod_1.z.object({
    categoryName: zod_1.z.string().min(1, "Category name is required."),
});
exports.createCategorySchema = createCategorySchema;
const editCategorySchema = zod_1.z.object({
    categoryName: zod_1.z.string().min(1, "Category name is required.").optional(),
});
exports.editCategorySchema = editCategorySchema;
