"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateAnnouncementSchema = exports.createAnnouncementSchema = void 0;
const zod_1 = require("zod");
const createAnnouncementSchema = zod_1.z.object({
    title: zod_1.z.string().min(1, "Title is required"),
    label: zod_1.z
        .string()
        .transform((val) => val.toLowerCase()) // Normalize to lowercase
        .refine((val) => ["pengumuman", "tutorial"].includes(val), {
        message: "Label must be either 'Pengumuman' or 'Tutorial'",
    }),
    description: zod_1.z.string().min(1, "Description is required"),
    sharedToRole: zod_1.z.array(zod_1.z
        .string()
        .transform((val) => val.toLowerCase()) // Normalize to lowercase
        .refine((val) => ["superadmin", "admin", "viewer", "editor", "allusers"].includes(val), {
        message: "Invalid role",
    })),
    specificUsers: zod_1.z.array(zod_1.z.string()).optional(),
});
exports.createAnnouncementSchema = createAnnouncementSchema;
// Update schema
const updateAnnouncementSchema = zod_1.z.object({
    title: zod_1.z.string().optional(),
    label: zod_1.z
        .string()
        .transform((val) => val.toLowerCase()) // Normalize to lowercase
        .refine((val) => ["pengumuman", "tutorial"].includes(val))
        .optional(),
    description: zod_1.z.string().optional(),
    sharedToRole: zod_1.z
        .array(zod_1.z
        .string()
        .transform((val) => val.toLowerCase()) // Normalize to lowercase
        .refine((val) => ["superadmin", "admin", "viewer", "editor", "allusers"].includes(val)))
        .optional(),
    specificUsers: zod_1.z.array(zod_1.z.string()).optional(),
});
exports.updateAnnouncementSchema = updateAnnouncementSchema;
