"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const users_1 = require("../app/controllers/api/v1/users");
const multer_1 = __importDefault(require("multer"));
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const upload = (0, multer_1.default)();
const router = express_1.default.Router();
router.put("/v1/users/:userId", upload.none(), verifyToken_1.default, users_1.updateUser);
router.post("/v1/users", upload.none(), verifyToken_1.default, users_1.addNewUser);
router.get("/v1/users", verifyToken_1.default, users_1.viewAllUsers);
router.get("/v1/listUsers", verifyToken_1.default, users_1.viewAllUsersClient);
router.delete("/v1/users/:userId", verifyToken_1.default, users_1.deleteUser);
router.get("/v1/listUsers", verifyToken_1.default, users_1.getUserSuggestions);
exports.default = router;
