"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const trash_1 = require("../app/controllers/api/v1/trash");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/restoreTrashItem/:itemId", verifyToken_1.default, trash_1.restoreFromTrash);
router.post("/v1/restoreAllTrashItem/:workspaceId", verifyToken_1.default, trash_1.restoreAllFromTrash);
router.get("/v1/viewTrashItem/:workspaceId", verifyToken_1.default, trash_1.viewTrashedItems);
router.delete("/v1/deleteTrashItem/:workspaceId/:itemId", verifyToken_1.default, trash_1.deleteFromTrash);
router.delete("/v1/deleteAllTrashItem/:workspaceId", verifyToken_1.default, trash_1.deleteAllFromTrash);
exports.default = router;
