"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const rekaman_1 = require("../app/controllers/api/v1/rekaman");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/rekaman/:workspaceId", upload.single("docs"), verifyToken_1.default, rekaman_1.createRekaman);
router.put("/v1/rekaman/:workspaceId/:rekamanFolderId/:rekamanId", upload.single("docs"), verifyToken_1.default, rekaman_1.editRekaman);
router.get("/v1/viewAllRekaman/:workspaceId", verifyToken_1.default, rekaman_1.viewAllRekaman);
router.get("/v1/viewAllRekamaninFolder/:workspaceId/:rekamanFolderId", verifyToken_1.default, rekaman_1.viewAllRekamanInFolder);
router.get("/v1/viewRekaman/:workspaceId/:rekamanFolderId/:rekamanId", verifyToken_1.default, rekaman_1.viewRekaman);
router.delete("/v1/deleteRekaman/:workspaceId/:rekamanFolderId/:rekamanId", verifyToken_1.default, rekaman_1.deleteRekaman);
exports.default = router;
