"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const plans_1 = require("../app/controllers/api/v1/plans");
const companies_1 = require("../app/controllers/api/v1/companies");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
router.post("/v1/plans", verifyToken_1.default, plans_1.createPlans);
router.get("/v1/plans", verifyToken_1.default, plans_1.getPlans);
router.get("/v1/companyPlans", verifyToken_1.default, plans_1.checkCompanyPlan);
router.put("/v1/UpdateCompaniesPlans", verifyToken_1.default, companies_1.updateCompaniesPlan);
exports.default = router;
