"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const notifications_1 = require("../app/controllers/api/v1/notifications");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.put("/v1/:workspaceId/notifications/:notificationId/read", upload.none(), verifyToken_1.default, notifications_1.updateRecipientIsRead);
router.put("/v1/:workspaceId/notifications/read", upload.none(), verifyToken_1.default, notifications_1.markAllNotificationsAsRead);
router.get("/v1/:workspaceId/notifications", upload.none(), verifyToken_1.default, notifications_1.viewNotifications);
exports.default = router;
