"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = __importDefault(require("../router/auth"));
const plans_1 = __importDefault(require("../router/plans"));
const users_1 = __importDefault(require("../router/users"));
const roles_1 = __importDefault(require("../router/roles"));
const workspace_1 = __importDefault(require("../router/workspace"));
const companies_1 = __importDefault(require("../router/companies"));
const divisiFolder_1 = __importDefault(require("../router/divisiFolder"));
const categoryDocument_1 = __importDefault(require("../router/categoryDocument"));
const document_1 = __importDefault(require("../router/document"));
const task_1 = __importDefault(require("../router/task"));
const trash_1 = __importDefault(require("../router/trash"));
const announcements_1 = __importDefault(require("../router/announcements"));
const chart_1 = __importDefault(require("../router/chart"));
const categoryRecord_1 = __importDefault(require("../router/categoryRecord"));
const rekamanFolder_1 = __importDefault(require("../router/rekamanFolder"));
const rekaman_1 = __importDefault(require("../router/rekaman"));
const commentsNotification_1 = __importDefault(require("../router/commentsNotification"));
const notification_1 = __importDefault(require("../router/notification"));
const generateDocument_1 = __importDefault(require("../router/generateDocument"));
const onlyoffice_1 = __importDefault(require("../router/onlyoffice"));
const documentApproval_1 = __importDefault(require("../router/documentApproval"));
const routers = express_1.default.Router();
routers.use(plans_1.default);
routers.use(auth_1.default);
routers.use(users_1.default);
routers.use(roles_1.default);
routers.use(workspace_1.default);
routers.use(companies_1.default);
routers.use(divisiFolder_1.default);
routers.use(categoryDocument_1.default);
routers.use(document_1.default);
routers.use(task_1.default);
routers.use(trash_1.default);
routers.use(announcements_1.default);
routers.use(chart_1.default);
routers.use(categoryRecord_1.default);
routers.use(rekamanFolder_1.default);
routers.use(rekaman_1.default);
routers.use(commentsNotification_1.default);
routers.use(notification_1.default);
routers.use(generateDocument_1.default);
routers.use(onlyoffice_1.default);
routers.use(documentApproval_1.default);
exports.default = routers;
