"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../app/controllers/api/v1/auth");
const multer_1 = __importDefault(require("multer"));
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/auth/register", upload.none(), auth_1.register);
router.post("/v1/auth/resetPassword", auth_1.resetPassword);
router.post("/v1/auth/login", upload.none(), auth_1.login);
router.get("/v1/checkAuth", verifyToken_1.default, auth_1.checkAuth);
router.post("/v1/auth/logout", verifyToken_1.default, auth_1.logout);
router.put("/v1/auth/profile", upload.single("image"), verifyToken_1.default, auth_1.updateUserProfile);
router.put("/v1/auth/change-password", upload.none(), verifyToken_1.default, auth_1.changePassword);
exports.default = router;
