"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const announcements_1 = require("../app/controllers/api/v1/announcements");
const verifyToken_1 = __importDefault(require("../middlewares/verifyToken"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)();
router.post("/v1/announcements/:workspaceId", upload.none(), verifyToken_1.default, announcements_1.createAnnouncement);
router.get("/v1/announcements/:workspaceId", verifyToken_1.default, announcements_1.getAnnouncements);
router.get("/v1/announcements/:workspaceId/:announcementId", verifyToken_1.default, announcements_1.viewAnnouncement);
router.put("/v1/announcements/:workspaceId/:announcementId", upload.none(), verifyToken_1.default, announcements_1.updateAnnouncement);
router.delete("/v1/announcements/:workspaceId/:announcementId", verifyToken_1.default, announcements_1.deleteAnnouncement);
exports.default = router;
