"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkCompanyPlan = exports.getPlans = exports.createPlans = void 0;
const firebase_admin_1 = require("../../../../utils/firebase-admin");
const predefinedPlans = [
    {
        name: "Free",
        userLimit: 5,
        storageLimit: 10,
        workspaceLimit: 1,
        price: 0,
        description: "Free Plan",
    },
    {
        name: "Basic",
        userLimit: 10,
        storageLimit: 30,
        workspaceLimit: 3,
        price: 200000,
        description: "Basic Plan",
    },
    {
        name: "Standard",
        userLimit: 50,
        storageLimit: 100,
        workspaceLimit: 10,
        price: 1000000,
        description: "Standard Plan",
    },
    {
        name: "Premium",
        userLimit: 1000,
        storageLimit: 1000,
        workspaceLimit: 100,
        price: 2000000,
        description: "Premium Plan",
    },
];
const createPlans = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (!firebase_admin_1.adminDb) {
            throw new Error("Firestore has not been initialized.");
        }
        const batch = firebase_admin_1.adminDb.batch();
        predefinedPlans.forEach((plan) => {
            const docRef = firebase_admin_1.adminDb.collection("plans").doc(plan.name);
            batch.set(docRef, plan);
        });
        yield batch.commit();
        return res.status(201).json({
            status: "success",
            code: 201,
            message: "Plans created successfully!",
        });
    }
    catch (error) {
        return res.status(500).json({
            status: "error",
            code: 500,
            message: "Internal Server Error",
        });
    }
});
exports.createPlans = createPlans;
const getPlans = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const plansSnapshot = yield firebase_admin_1.adminDb.collection("plans").get();
        const plans = plansSnapshot.docs.map((doc) => doc.data());
        return res.status(200).json({
            status: "success",
            code: 200,
            data: plans,
        });
    }
    catch (error) {
        return res.status(500).json({
            status: "error",
            code: 500,
            message: "Internal Server Error",
        });
    }
});
exports.getPlans = getPlans;
const checkCompanyPlan = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const user = req.user;
        const companyId = user.companyId;
        if (!companyId) {
            return res.status(400).json({
                status: "error",
                code: 400,
                message: "Company ID is missing.",
            });
        }
        // Fetch the company document
        const companySnapshot = yield firebase_admin_1.adminDb
            .collection("companies")
            .doc(companyId)
            .get();
        if (!companySnapshot.exists) {
            return res.status(404).json({
                status: "error",
                code: 404,
                message: "Company not found.",
            });
        }
        const companyData = companySnapshot.data();
        if (!(companyData === null || companyData === void 0 ? void 0 : companyData.plan)) {
            return res.status(404).json({
                status: "error",
                code: 404,
                message: "No plan associated with this company.",
            });
        }
        const { plan } = companyData;
        return res.status(200).json({
            status: "success",
            code: 200,
            data: {
                company: companyData.name,
                plan,
            },
        });
    }
    catch (error) {
        return res.status(500).json({
            status: "error",
            code: 500,
            message: "Internal Server Error",
        });
    }
});
exports.checkCompanyPlan = checkCompanyPlan;
