"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
require("dotenv").config();
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const index_1 = __importDefault(require("./router/index"));
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const helmet_1 = __importDefault(require("helmet"));
const http_1 = __importDefault(require("http"));
const node_cron_1 = __importDefault(require("node-cron"));
const task_1 = require("./app/controllers/api/v1/task");
const express_rate_limit_1 = require("express-rate-limit");
const csrf_csrf_1 = require("csrf-csrf");
const limiter = (0, express_rate_limit_1.rateLimit)({
    windowMs: 10 * 60 * 1000,
    limit: 250,
    standardHeaders: 'draft-8',
    legacyHeaders: false,
});
const { invalidCsrfTokenError, generateToken, doubleCsrfProtection } = (0, csrf_csrf_1.doubleCsrf)({
    getSecret: () => process.env.csrf_SECRET_KEY || "",
    cookieName: "csrftoken",
    cookieOptions: {
        httpOnly: true,
        signed: true,
        secure: process.env.NODE_ENV === "production", // Use secure cookies in production
        sameSite: "strict",
    },
    size: 64,
    ignoredMethods: ["GET", "HEAD", "OPTIONS"],
});
const csrfErrorHandler = (error, req, res, next) => {
    if (error == invalidCsrfTokenError) { // Check if the error is an instance of the invalid CSRF error
        return res.status(403).json({
            status: "error",
            code: 403,
            message: "CSRF Validation error",
            error: "CSRF validation error",
        });
    }
    else {
        next(error); // Pass the error to the next middleware if it's not related to CSRF
    }
};
const app = (0, express_1.default)();
const PORT = 3000;
const corsOptions = {
    credentials: true,
    origin: [
        "http://localhost:5173",
        "https://testclientdms.mitraberdaya.id",
        "http://127.0.0.1:5500/",
        "http://localhost:80",
        "http://localhost",
    ],
    optionsSuccessStatus: 200,
};
node_cron_1.default.schedule("0 0 * * *", () => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, task_1.checkDeadlinesAndSendEmails)();
}), {
    timezone: "Asia/Jakarta",
});
app.use((0, helmet_1.default)());
app.use((0, cors_1.default)(corsOptions));
app.use((0, cookie_parser_1.default)(process.env.csrf_SECRET_KEY || 'your-secret-key'));
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
app.use(limiter);
app.use((req, res, next) => {
    const csrfExcludedPaths = [
        "/v1/viewDocumentOffice",
        "/v1/viewRekamanOffice",
        "/v1/viewDocumentApprovalOffice",
        "/v1/restoreDocumentOffice",
        "/v1/restoreRekamanoffice",
        "/v1/convertDocumentOffice",
        "/v1/trackDocumentOffice",
        "/v1/trackRekamanOffice",
        "/v1/trackDocumentApprovalOffice",
        "/v1/createDocumentOffice",
        "/v1/createRekamanFile",
    ];
    // Check if the request path matches any excluded path
    const isExcluded = csrfExcludedPaths.some((path) => req.path.startsWith(path));
    if (isExcluded) {
        return next(); // Skip CSRF protection
    }
    doubleCsrfProtection(req, res, next); // Apply CSRF protection
});
// Mount routers
app.use(index_1.default);
app.get("/v1/csrf-token", function (req, res) {
    const csrfToken = generateToken(req, res);
    res.cookie("XSRF-TOKEN", csrfToken);
    res.json({ message: "CSRF token generated", csrfToken });
});
app.use(index_1.default);
app.use(csrfErrorHandler);
// Create HTTP server
const server = http_1.default.createServer(app);
server.listen(PORT, () => {
    console.log(`Running on Port ${PORT}`);
});
